﻿using Helper;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using ZSMusic.BLL;
using ZSMusic.DAL;
using ZSMusic.Model;

namespace WEB
{
    public partial class demo : System.Web.UI.Page
    {
        public List<Music> Result
        {
            get { return ViewState["result"] as List<Music>; }
            set { ViewState["result"] = value; }
        }

        public int Pn
        {
            get { return (int)ViewState["pn"];}
            set { ViewState["pn"] = value; }
        }

        public int Num
        {
            get {
                if (string.IsNullOrWhiteSpace(txtNum.Text))
                { return 30; }
                return int.Parse(txtNum.Text); }
            set { txtNum.Text = value.ToString(); }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            Pn = 1;
            if (IsPostBack) { return; }
            Response.Write("<script type=\"text/javascript\">\nalert(\"今天你离群体免疫又近了一步!\");</script>");
            LoadSources();
        }
        /// <summary>
        /// 加载音乐源
        /// </summary>
        public void LoadSources()
        {
            cboSource.Items.Clear();
            List<MusicSource> source = Info.Sources;
            foreach (MusicSource item in source)
            {
                if (item.Enabled)
                {
                    cboSource.Items.Add(new ListItem(item.DisplayName, item.Value, item.SuppwotWeb));
                }
            }
            if (cboSource.Items.Count > 0)
            { cboSource.SelectedIndex = 0; }
        }
        protected void btnSearch_Click(object sender, EventArgs e)
        {
            Pn = 1;
            Search();
        }

        private void Search()
        {
            btnUp.Enabled = Pn != 1;
            Result = MusicHelper.Search(cboSource.SelectedValue, txtWord.Text.Trim(), Pn, Num);
            ModelConvertHelper<Music> h = new ModelConvertHelper<Music>();
            dgvMusic.DataSource = h.ListToDataTable(Result);
            dgvMusic.DataBind();
        }

        protected void dgvMusic_DataBinding(object sender, EventArgs e)
        {

        }
        protected void dgvMusic_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            Music m = Result[Convert.ToInt32(e.CommandArgument)];
            switch (e.CommandName)
            {
                case "play":
                    if (!MusicHelper.GetData(m, "url"))
                    {
                        m = MusicHelper.ReSearch(m, 0.75);
                    }
                    Response.Redirect(m.Url);
                    break;
                case "detail":
                    Response.Redirect(string.Format(
                    "detail.aspx?source={0}&id={1}&name={2}&artist={3}&album={4}&album={5}"
                    , m.Source, m.Id, m.Name, m.Artist, m.Album, m.AlbumId));
                    break;
                default:
                    break;
            }
        }

        protected void btnUp_Click(object sender, EventArgs e)
        {
            Pn--;
            Search();
        }

        protected void btnDown_Click(object sender, EventArgs e)
        {
            Pn++;
            Search();
        }
    }
}